package simpleTypes;

public class FunExample {
	
	// a function type
	interface Int_String_Fun {
		String fun(int i);
	}
	
	public static void main(String[] args) {
		
		// introduction
		// A pretty inconvenient way to specify a lambda
		Int_String_Fun f = new Int_String_Fun() {
			@Override
			public String fun(int i) {
				return "output of f=" + i;
			}
		};
		Int_String_Fun g = new Int_String_Fun() {
			@Override
			public String fun(int i) {
				return "output of g=" + i;
			}
		};
		
		// Since Java 8, a better lambda notation
		Int_String_Fun h = (int i) -> "output of h=" + i;
		// In Java, lambdas can produce side effects
		Int_String_Fun h2 = (int i) -> {
			int j=0;
			while (i != 0) {
				System.out.println("h2 considers "+i);
				j+=i;
				i--;
			}
			return "output of h2=" + j;
		};
		
		// elimination
		System.out.println(f.fun(42));
		System.out.println(g.fun(31));
		System.out.println(h.fun(31));
		System.out.println(h2.fun(5));
	}

}
